/*=========================================================================
 Copyright (c), 1991-2007, T&W ELECTRONICS(SHENTHEN) Co., Ltd.
 ļ : flash_layout.h
 ļ : flash imageֵĶ


 ޶¼ :
          1  : 
             : 2008-9-12
             :

          2 ޶: 
             : 2009-3-16
             : ŻĿĲ


=========================================================================*/
#ifndef _FLASH_LAYOUT_H_
#define _FLASH_LAYOUT_H_
#include "autoconf.h"

/*=========================================================================
	ײϢвƷơ汾Ϣ
	imageкַȵĶ
=========================================================================*/

#define TBS_MAGIC			0x48534254		/* TBSH */
#define PRODUCT_NAME_LEN			32
#define TBS_VERSION_NAME_LEN		16
#define IMAGE_TYPES_NAME_LEN		5
#define BOARD_ID_NAME_LEN			12
#define MODEL_LEN			16
#define REGION_LEN			4
#define VERSION_LEN			16
#ifdef PINANDOTHER_ENABLED
#define PINANDOTHER_LEN         64
#endif
#ifdef CONFIG_DRIVER_PLC
#define PLC_NPW_LEN			32
#define PLC_DPW_LEN			32
#endif
#define GUI_REGION_LEN			24


#define		ZONE_BOOTLOADER			0
#define		ZONE_KERNEL_FIRST			1
#define		ZONE_ROOTFS_FIRST			2
#define		ZONE_KERNEL_SECOND		3
#define		ZONE_ROOTFS_SECOND		4
#define		ZONE_EXTFS					5

#if 1 //use multi language
#define     ZONE_MULTI_LANG             6
#define     ZONE_MAX_ITEM               7

#define 	CONFIG_CAL_DATA_SIZE 128
#ifdef CONFIG_CAL_DATA_SIZE  //default 128Kb
#define 	MULTI_LANG_LENGTH      (CONFIG_CAL_DATA_SIZE *1024)
#endif

#else //no use multi language
#define     ZONE_MAX_ITEM               6
#endif


/* Bootloader̶ռ64KBС,u-boot.bin */
//#define	BOOTCODE_LENGTH		( 0x10000 )
#define	BOOTCODE_LENGTH		( 0x40000 )
#define FIX_ONE_PAGE_SIZE   ( 0x10000 )
#define	NETGEAR_POT_LENGTH	( 0x10000 )
#define	PLC_DATA_LENGTH	( 0x50000 )

#define	BCM_NVRAM_LENGTH	( 0x10000 )
#define PLC_BOOT_OS_LENGTH      ( 0x100000 )
#define PLC_BOOT_OS_ADDR       (0x6a0000)
//add by wyh start to add WIFI NMPR function
#define 	NMRP_FIRST_FRAGMENT		0
#define 	NMRP_MIDDLE_FRAGMENT	1
#define		NMRP_LAST_FRAGMENT		2
//add by wyh end

#ifdef CONFIG_PLC_SINGLE_FLASH
#define FW_FILE "/var/fw.bin"
#define UCODES_FILE "/var/ucode.bin"
#define FLASHBLOCK "plcos"
#endif


/*=========================================================================
	flash imageֵľ嶨壬ڴʱʼ
=========================================================================*/

typedef struct
{
	unsigned int 			zone_offset[ZONE_MAX_ITEM];
} flash_layout_t;

typedef struct
{
	flash_layout_t		layout;
	unsigned int		ip;
	unsigned int		first_image_len;
	unsigned int		first_image_checksum;
	unsigned int		second_image_len;
	unsigned int		second_image_checksum;
	unsigned char 	    mac[6];
	unsigned char		endian;
	unsigned char		image_mark;							/*0: ϵͳimage11: ϵͳimage 2*/
	unsigned char 	    board_id[BOARD_ID_NAME_LEN];			/*ͻǩ*/     
	unsigned char		product[PRODUCT_NAME_LEN];				/*ʶ*/
	unsigned char		version[TBS_VERSION_NAME_LEN];			/*汾Ϣ*/
    
    //the following 3 items for netgear
    unsigned char              model_name[MODEL_LEN]; /*ģ*/
    unsigned char              region[REGION_LEN];       /**/
    //swversion汾ţ1.0.6.2 ȥеĵ1062, versionTBSϵͳ汾R2
    unsigned char              swversion[VERSION_LEN]; /*汾*/
    
    #ifdef PINANDOTHER_ENABLED
    unsigned char              pinandother[PINANDOTHER_LEN]; /*PINԼԤռ䣬*/
    #endif 
    unsigned char              gui_region[GUI_REGION_LEN];/*Ĭ*/
	#ifdef CONFIG_DRIVER_PLC
	unsigned char              plc_npw[PLC_NPW_LEN];/*plc factory NPW*/
	unsigned char              plc_dpw[PLC_DPW_LEN];/*plc factory DPW*/
	#endif
    unsigned char              Reserve1[32];/*չֶ*/
    unsigned char              Reserve2[32];/*չֶ*/
    unsigned char              Reserve3[32];/*չֶ*/
	unsigned char		tag[4];									/*  ײÿʶ'sysc'  */
} sys_config_t;

#define		SYSCFG_SIZE			( sizeof( sys_config_t ) )






/*=========================================================================
	image.binβϢݽṹڴʱʼ
=========================================================================*/

#define	IMAGE_BIN				"bin"

typedef struct
{
	unsigned char		product[PRODUCT_NAME_LEN];				/*ʶ*/
	unsigned char		bin_type[4];								/*BIN fileʶ*/
} image_bin_tail_t;






/*=========================================================================
	image.imgͷϢݽṹڴʱʼ
=========================================================================*/

typedef struct
{
	unsigned int 			magic;		
	unsigned int 			image_checksum;					/*imageУ*/
	unsigned int			kernel_offset;
	unsigned int 			rootfs_offset;
	unsigned int 			kernel_size;
	unsigned int 			rootfs_size;
	unsigned int			image_len;
	unsigned char			img_type[IMAGE_TYPES_NAME_LEN]; 	/*ļʶimageΪ:imgs    ˫Ϊ:imgd*/
	unsigned char 		board_id[BOARD_ID_NAME_LEN];		/*ͻǩ*/    
	unsigned char			product[PRODUCT_NAME_LEN];			/*ʶ*/
	unsigned char			version[TBS_VERSION_NAME_LEN];		/*汾Ϣ*/
      //the following 3 items for netgear
      unsigned char              model_name[MODEL_LEN]; /*ģ*/
      unsigned char              region[REGION_LEN];       /**/
      unsigned char              swversion[VERSION_LEN]; /*汾*/
      unsigned char              gui_region[GUI_REGION_LEN]; /*Ĭ*/
} update_hdr_t;

/*=========================================================================
	imgd: ʾϵͳ˫imageϵͳ
	imgs: ʾϵͳǵimageϵͳ
	ҲԱⵥ˫imageϵͳĴ
	bin:ʶļΪBINļ
=========================================================================*/

#ifdef CONFIG_DOUBLE_BACKUP
#define	IMAGE_TYPES			"imgd"
#else
#define	IMAGE_TYPES			"imgs"
#endif


//add by wyh start to add WIFI NMRP function
/*=========================================================================
	image ļƬݽṹ
=========================================================================*/

typedef struct
{
	unsigned short			fragtype;
	unsigned char			nmrp_error;
	unsigned short			len;
	unsigned char			*data;				/* */
} nmrp_frag_t;
//add by wyh end

/*=========================================================================
	ϢĿݽṹ
=========================================================================*/

typedef struct
{
	unsigned short		crc;
	unsigned short		len;
	unsigned char			avail;
} __attribute__ ((packed))  item_hdr_t;

typedef struct
{
	item_hdr_t			hdr;
	unsigned char			data[];				/* */
} item_t;

#define		ITEM_HEAD_LEN					( sizeof( item_hdr_t ) )
#define		ITEM_SIZE( data_len )			( ( ITEM_HEAD_LEN + ( data_len ) ) + ( ( ITEM_HEAD_LEN + ( data_len ) ) % 2 ) )

#define		CONFIG_MARK		"OK"
#define		CONFIG_MARK_LEN	( strlen( CONFIG_MARK ) )

#define		ITEM_UNAVAIL	0x00
#define		ITEM_AVAIL		0x11
#define		ITEM_BAD		0x22


/*=========================================================================
	ݽṹӦӿioctlʱײݽ
=========================================================================*/

typedef struct
{
	unsigned char			*name;
	unsigned char			item_error;
	unsigned short		len;
	unsigned char			*data;				/* */
} item_app_t;

/*=========================================================================
	ϵͳʹõĿƣĿú궨
	ڹά
=========================================================================*/

#define		LLCONFIG_NAME			"llconfig"
#define		WLAN_NAME				"wlan_cfg"
#define		WLAN_NAME_5G			"wlan_cfg_5g"
#define		TBS_APP_CFG			    "tbs_app_cfg"
#define		TR069_EVENT			    "tr069_event"
#define		PPPOE_SSID			    "pppoe_ssid"
#define     BOOT_TIMES              "boot_times"

#define     TBS_BIT_FLAG            "tbs_bit_flag"
#define     TBS_DEFCFG_PATH         "def_cfg_path"
#define     TBS_USERCFG_ITEM        "user_cfg_item"
#define     TBS_USERCFG_PREFIX		"tbs_app_cfg_"
#define     TBS_RESET_FLAG			"reset_flag"
#define     TBS_WiZARD_FLAG			"wizard_flag"	//µҪָҳıʶ sdh 2014-7-8
/*=========================================================================
	ڶĿʱصĴ
=========================================================================*/

enum item_error
{
	ERROR_ITEM_OK = 0,
	ERROR_ITEM_MTD,
	ERROR_ITEM_IOCTRL,
	ERROR_ITEM_MALLOC,
	ERROR_ITEM_NOT_FIND,
	ERROR_ITEM_CRC,
	ERROR_ITEM_BIG,
	ERROR_ITEM_REPEAT_OK,
	ERROR_ITEM_REPEAT_FAIL,
	ERROR_CONFIG_LOST,
	ERROR_FLASH_BUSY
};

/*=========================================================================
	ӦòȡͱĿĽӿ
=========================================================================*/

int app_item_get( void *data , char *item_name ,unsigned short *len );		/* ȡӦĿϢ*/
int app_item_save( void *data , char *item_name ,unsigned short len );		/* Ŀ*/

/*=========================================================================
	ײȡͱĿĽӿ
=========================================================================*/
int item_get( void *data , char *item_name ,unsigned short *len );		/* ȡӦĿϢ*/
int item_save( void *data , char *item_name ,unsigned short len );		/* Ŀ*/





/*=========================================================================
	ӦòȡMACַַӿ
=========================================================================*/

typedef struct
{
	int 				id;
	int				offset;
	unsigned char		mac[6];
} mac_t;


typedef struct
{
	unsigned char		region[2];
} region_t;


#ifdef PINANDOTHER_ENABLED
typedef struct
{
    unsigned char       pinandother[PINANDOTHER_LEN];
} pin_t;
#endif

typedef struct
{
    unsigned char       gui_region[GUI_REGION_LEN];
} gui_region_t;

#ifdef CONFIG_DRIVER_PLC
typedef struct
{
    unsigned char       plc_npw[PLC_NPW_LEN];
} plc_npw_t;

typedef struct
{
    unsigned char       plc_dpw[PLC_DPW_LEN];
} plc_dpw_t;

#endif

enum device_mac
{
	LAN_MAC = 0,
	WAN_MAC,
	WLAN_MAC,
	USB_MAC,
	PLC_MAC
};

int tbs_read_mac( int id , int offset , unsigned char *mac );
int app_tbs_read_mac( int id , int offset , unsigned char *mac );
int tbs_read_region(unsigned char *region);
int app_tbs_read_region(unsigned char *region);

#ifdef PINANDOTHER_ENABLED
int tbs_read_pinandother(unsigned char *region);
int app_tbs_read_pinandother(unsigned char *pin);
#endif
int tbs_read_gui_region(unsigned char *gui_region);
int app_tbs_read_gui_region(unsigned char *gui_region);
#ifdef CONFIG_DRIVER_PLC
int tbs_read_plc_npw(unsigned char *plc_npw);
int app_tbs_read_plc_npw(unsigned char *plc_npw);
int tbs_read_plc_dpw(unsigned char *plc_dpw);
int app_tbs_read_plc_dpw(unsigned char *plc_dpw);
#endif
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin start*/
/*=========================================================================
	binļָ
=========================================================================*/
#define BACKUP_ITEM_MIB_RF_MAC

#ifdef BACKUP_ITEM_MIB_RF_MAC
typedef struct llconfig_syscfg
{
	unsigned char mac[6];
	unsigned char 	    board_id[BOARD_ID_NAME_LEN];			/*ͻǩ*/   
	unsigned char              region[REGION_LEN];
	#ifdef PINANDOTHER_ENABLED
    unsigned char              pinandother[PINANDOTHER_LEN];
    #endif
    unsigned char              gui_region[GUI_REGION_LEN];  
#ifdef CONFIG_DRIVER_PLC
	unsigned char              plc_npw[PLC_NPW_LEN];/*plc factory NPW*/
	unsigned char              plc_dpw[PLC_DPW_LEN];/*plc factory DPW*/
#endif	
}llconfig_syscfg_t;
#endif
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/

typedef struct plc_os_header
{
	char szName[32];
	unsigned int iLen;
}plc_os_header_t;

#endif  /*_FLASH_LAYOUT_H_*/

